using System;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages;

namespace gov.va.med.vbecs.DAL.VistALink.Client
{
	/// <summary>
	/// This exception is thrown whenever client receives unexpected message from server.
	/// </summary>
	public class UnexpectedServerResponseException : VistALinkException
	{
		private VistALinkMessage _unexpectedMessage;

		/// <summary>
		/// Default constructor. Error message is self-contained and cannot be changed.
		/// </summary>
		public UnexpectedServerResponseException()
			: base( SR.Exceptions.UnexpectedMessageReceived() ) {}

		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public UnexpectedServerResponseException( string message )
			: base( message ) {}

		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="innerException">Inner exception that caused this exception.</param>
		public UnexpectedServerResponseException( string message, Exception innerException )
			: base( message, innerException ) {}

		/// <summary>
		/// This constructor allows specyfying unexpectedly received <see cref="VistALinkMessage"/> 
		/// and error message upon throwing an exception.
		/// </summary>
		/// <param name="message">String exception message.</param>
		/// <param name="unexpectedMessage">Actually received unexpected message.</param>
		public UnexpectedServerResponseException( string message, VistALinkMessage unexpectedMessage )
			: this( message )
		{
			_unexpectedMessage = unexpectedMessage;
		}

		/// <summary>
		/// This constructor allows specyfying unexpectedly received <see cref="VistALinkMessage"/> 
		/// upon throwing an exception. Error message is self-contained and cannot be changed.
		/// </summary>
		/// <param name="unexpectedMessage">Actually received unexpected message.</param>
		public UnexpectedServerResponseException( VistALinkMessage unexpectedMessage )
			: this( SR.Exceptions.UnexpectedMessageReceived(), unexpectedMessage ) {}
	
		/// <summary>
		/// Actually received unexpected message.
		/// </summary>
		public VistALinkMessage UnexpectedMessage
		{
			get
			{
				return _unexpectedMessage;
			}
		}
	}
}
